/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50, sloppy: true, continue: true */
/*globals $, app, BRUSH, FLfile, COLOR, JSXGlobals, Folder */

// Load other helper functions
// Get the root folder name from the scriptURI of current script
var jsxROOT = FLfile.uriToPlatformPath(app.scriptURI.split('/').slice(0, -1).join('/') + '/');
$.evalFile(jsxROOT + "brush.jsx");
$.evalFile(jsxROOT + "color.jsx");

// Layer types
var LayerType = {
    'NORMAL': 'normal',
    'GUIDE': 'guide',
    'GUIDED': 'guided',
    'MASK': 'mask',
    'MASKED': 'masked',
    'FOLDER': 'folder'
};

var ElementType = {
    'TEXT': 'text',
    'SHAPE': 'shape'
};

var FillStyle = {
    'SOLID': 'solid',
    'LIN_GRAD': 'linearGradient',
    'RAD_GRAD': 'radialGradient'
};

$._ADBE_LIBS_FLPR = {
    loadAndSelectBrush: BRUSH.loadAndSelectBrush,
    setColor: COLOR.setColor,
    getTooltipState: function () {
        // Flash Pro has tooltips enabled always
        return 'true';
    },
    isAnalyticsEnabled: function () {
        return app.isAnalyticsEnabled();
    },
    getCurrentState: function () {
        try {
            var activeDoc = app.getDocumentDOM();
            if (activeDoc && activeDoc.timelines && activeDoc.currentTimeline >= 0 && activeDoc.currentTimeline < activeDoc.timelines.length) {
                var activeTimeline = activeDoc.timelines[activeDoc.currentTimeline];
                var selectedLayerId = activeTimeline.currentLayer;
                var docPath = activeDoc.path;
                if (!docPath) {
                    // If document is not saved, return just the name
                    docPath = activeDoc.name;
                }

                return JSON.stringify({
                    'path': docPath,
                    'layerID': selectedLayerId
                });
            }
        } catch (ex) {}
        return JSON.stringify({
            'path': '',
            'layerID': -1
        });
    },
    isFontAvailable: function (style) {
        // TODO: Implement a function that returns true or false, depending on whether the given font is available
        // in your application.
        return 'false';
    },
    getLayerInfo: function () {
        // We return the information based on the current selection in this callback, which is what is needed to enable/disable
        // certain UI options. Its not returning the information for the entire layer
        var layerObject = {'name': '', 'fullName': ''};
        var layerColors = [];

        try {
            var activeDoc = app.getDocumentDOM();
            if (activeDoc) {
                var mergeForSelectionFlag = activeDoc.mergeForSelection;
                activeDoc.mergeForSelection = true;
                var selections = activeDoc.selection;
                if (selections && selections.length > 0) {
                    // Get the values from the first selected object
                    var selection = selections[0];

                    var areEqual = function (colorData1, colorData2) {
                        var key;
                        if (colorData1 && colorData2) {
                            for (key in colorData1[0].value) {
                                if (colorData1[0].value.hasOwnProperty(key)) {
                                    if (!colorData2[0].value.hasOwnProperty(key) || Math.round(colorData1[0].value[key]) !== Math.round(colorData2[0].value[key])) {
                                        return false;
                                    }
                                }
                            }
                        }
                        return true;
                    };

                    var pushUnique = function (colorData, colorType) {
                        if (colorData === undefined) {
                            return;
                        }
                        var index;
                        for (index = 0; index < layerColors.length; index++) {
                            if (areEqual(layerColors[index].data, colorData)) {
                                return;
                            }
                        }
                        layerColors.push({'colorType': colorType, 'data': colorData});
                    };

                    layerObject.enableApplyText = false;

                    // Disable text temporarily
                    // if (selection.elementType === ElementType.TEXT) {
                    //    layerObject.enableApplyText = true;
                    //    layerObject.text = $._ADBE_LIBS_CORE.shortenString(selection.getTextString());

                    //    // TODO: populate the font info
                    //    // layerObject.fontInfo = getFontInfo();
                    //    // pushUnique(layerObject.fontInfo.color, JSXGlobals.PS_TEXT);
                    //}
                    // Get the fill and stroke color from selection, not from the global app settings
                    try {
                        var fill = selection.getCustomFill(false);
                        // TODO: Handle other fill types
                        if (fill && fill.style === FillStyle.SOLID && fill.color) {
                            pushUnique(COLOR.colorStringToData(fill.color), JSXGlobals.FILL);
                        }
                    } catch (ex1) {}

                    try {
                        // Get the fill style of stroke and extract the color from that
                        var stroke = selection.getCustomStroke(false);
                        if (stroke) {
                            var strokeFill = stroke.shapeFill;
                            // TODO: Handle other fill types
                            if (strokeFill && strokeFill.style === FillStyle.SOLID && strokeFill.color) {
                                pushUnique(COLOR.colorStringToData(strokeFill.color), JSXGlobals.STROKE);
                            }
                        }
                    } catch (ex2) {}
                    layerObject.colors = layerColors;
                }
                layerObject.selectionExists = selections !== null;
                activeDoc.mergeForSelection = mergeForSelectionFlag;
                layerObject.kind = "";
                layerObject.enableApplyStyle = false;
                layerObject.enableShapeLayerApplyOperations = false;
                layerObject.libraryLinked = false;
                return JSON.stringify(layerObject);
            }
            return "";
        } catch (ex) {
            $._ADBE_LIBS_CORE.writeToLog('FLPR.jsx-getLayerInfo()', ex);
        }
        return JSON.stringify(layerObject);
    },
    placeAsset: function (filePath, libraryName, itemName, elementRef, modifiedTime, creationTime, isLinked) {
        try {
            if (app.getDocumentDOM() && filePath) {
                // Need to make a copy of the file to avoid overwrite
                var fileExtension = filePath.substr(filePath.lastIndexOf(".") + 1).toLowerCase();
                var destPath = Folder.temp.fsName + '/' + new Date().valueOf() + '.' + fileExtension;
                var sourceURI = FLfile.platformPathToURI(filePath);
                var destURI = FLfile.platformPathToURI(destPath);

                FLfile.copy(sourceURI, destURI);
                app.getDocumentDOM().importCCLibAsset(destURI, elementRef, modifiedTime, itemName, isLinked);
            }
        } catch (ex) {
            $._ADBE_LIBS_CORE.writeToLog('FLPR.jsx-placeAsset()', ex);
        }
    },
    reportEvent: function (eventName, properties) {
        try {
            if (eventName === "createElement" || eventName === "useElement" || eventName === "createLink") {
                // Log events to Highbeam so Design Library usage can be compared
                // to usage of other Flash features.
                var highbeamDataGroupName = "Design Library";

                 // Helper to handle null and undefined properties
                var safeGetStringProperty = function (property) {
                    return property || "N/A";
                };

                var data = {
                    'eventName' : safeGetStringProperty(eventName),
                    'libraryID' : safeGetStringProperty(properties.libraryID),
                    'elementType' : safeGetStringProperty(properties.elementType),
                    'opType' : safeGetStringProperty(properties.opType)
                };

                app.logPIPEvent(highbeamDataGroupName, JSON.stringify(data));

                return true;
            }

        } catch (ex) {
            $._ADBE_LIBS_CORE.writeToLog('FLPR.jsx-reportEvent()', ex);
        }

        return false;
    }
};
